/*

 ==----------=--=-=======-==-=============-=-=-=======--===--=-
   ___    ___      _______     __    _     _______     _______
 /__ /\ /__ /|    /_____ /|  /__/| /_/|  /_______/|  /_______/|
|    \/    | |  /   _   | | |   |/   |' | ___    |' | ___    |'
|          | | |   |/   | | |       <   ||/  /  /__ ||/  /  /__
|   |\/|   | | |    /|  | | |     <   \    /  /__//|   /  /__//|
|   | ||   | | |   | |  | | |       \ /| /  /___|| | /  /___|| |
|___|/ |___|/  |___|/|__|/  |___|\___|/ |________|/ |________|/

    +                 +             +          +
          +                      +                   +
	          +         +           +      +
	      +        +            +        +

*/
#include <amxmisc>

#define VERSION "1.0"

#define TASK_TEST		200
#define TASK_HURRY		300
#define MAX_KEYS		100
#define MAX_KEYS_SIZE	15

new bool:g_TestComplited[33], bool:g_MainKeysTested[33][MAX_KEYS], bool:g_OtherKeysTested[33][MAX_KEYS],
bool:g_Mode[33], bool:g_TestStarted[33]
new g_MainKeys[MAX_KEYS][MAX_KEYS_SIZE], g_OtherKeys[MAX_KEYS][MAX_KEYS_SIZE]
new i_MaxOtherKeys, i_MaxMainKeys
new g_StageKeys, g_Quick, g_HurryTime
new g_LastKey[33], g_Checked[33], g_Afk[33], g_Bind[5]

public plugin_init ()
{
	register_plugin ( "Giant Keyboard Test", VERSION, "Makzz" )
	
	register_dictionary ( "giant_keyboard_test.txt" )
	
	g_StageKeys		= register_cvar ( "gkt_stage_keys", "10" ) //      
	g_HurryTime		= register_cvar ( "gkt_hurry_time", "15" )
	g_Quick			= register_cvar ( "gkt_quick", "1" ) //     ,      
	
	register_menucmd ( register_menuid ( "keyboard_menu" ), 1023, "ActionMainMenu" )
	register_menucmd ( register_menuid ( "kickme_menu" ), 1023, "ActionKickMeMenu" )
	register_menucmd ( register_menuid ( "test_menu" ), 1023, "ActionTestMenu" )
	
	register_message ( get_user_msgid ( "ShowMenu" ), "message_ShowMenu" )
	register_message ( get_user_msgid ( "VGUIMenu" ), "message_VGUIMenu" )
	
	set_task ( 0.2, "LoadKeysFile" )
}

public LoadKeysFile ()
{
	new s_File[64]
	get_configsdir ( s_File, sizeof s_File -1 )
	
	format ( s_File, sizeof s_File -1, "%s/giant_keyboard_test/keys.ini", s_File )
	
	if ( file_exists ( s_File ) )
	{
		new Input[MAX_KEYS_SIZE], Line, Len, bool:s_Case
		while ( ( Line = read_file ( s_File, Line, Input, sizeof Input -1, Len ) ) != 0 )
		{
			if ( !Len || contain ( Input, "//" ) !=-1 )
				continue //   
			
			if ( equal ( Input, "[Main keys]" ) )
			{
				s_Case = false
				continue
			}
			
			if ( equal ( Input, "[Other keys]" ) )
			{
				s_Case = true
				continue
			}
			
			if ( s_Case ) // Other keys
			{
				g_OtherKeys[i_MaxOtherKeys] = Input
				i_MaxOtherKeys++
			}
			else
			{
				g_MainKeys[i_MaxMainKeys] = Input
				i_MaxMainKeys++
			}
		}
		server_print ( "[GKT] Loaded keys: %i main, %i other", i_MaxMainKeys, i_MaxOtherKeys )
		format ( g_Bind, 4, "t%i%i%i", random_num('0', '9'), random_num('0', '9'), random_num('0', '9') )
		register_clcmd ( g_Bind, "KeyPressed" )
		
	}
	else
	{
		server_print ( "[GKT] File not found '%s'", s_File )
	}
}

public message_ShowMenu ( iMsgid, iDest, id )
{
	new s_Msg[25]
	get_msg_arg_string ( 4, s_Msg, sizeof s_Msg - 1 )
	if ( equal ( s_Msg, "#Team_Select") || equal ( s_Msg, "#Team_Select_Spect" ) )
	{
		if ( is_user_bot ( id ) || is_user_hltv ( id ) )
			return PLUGIN_CONTINUE
		
		if ( !g_TestComplited[id] && !g_Checked[id] )
		{
			if ( !g_TestStarted[id] )
				DisplayTestMenu ( id )
			
			return PLUGIN_HANDLED
		}
	}
	return PLUGIN_CONTINUE
}

public message_VGUIMenu ( iMsgid, iDest, id )
{
	if ( get_msg_arg_int ( 1 ) == 2 )
	{
		if ( is_user_bot ( id ) || is_user_hltv ( id ) )
			return PLUGIN_CONTINUE
	
		if ( !g_TestComplited[id] && !g_Checked[id] )
		{
			if ( !g_TestStarted[id] )
				DisplayTestMenu ( id )
			
			return PLUGIN_HANDLED
		}
	}
	return PLUGIN_CONTINUE
}

public client_putinserver ( id )
{
	for ( new i; i < MAX_KEYS; i++ )
		g_MainKeysTested[id][i] = g_OtherKeysTested[id][i] = false
	
	g_Mode[id] = g_TestComplited[id] = g_TestStarted[id] = false
	g_LastKey[id] = g_Afk[id] = g_Checked[id] = 0
	
	//new s_Ip[32]
	//     
}

public client_disconnect ( id )
{
	g_Mode[id] = g_TestComplited[id] = g_TestStarted[id] = false
	g_LastKey[id] = g_Afk[id] = g_Checked[id] = 0
	
	remove_task ( id+TASK_TEST )
	remove_task ( id+TASK_HURRY )
}

public KeyPressed ( id )
{
	if ( !g_TestStarted[id] )
		return PLUGIN_HANDLED
	
	new s_Command[4]
	read_argv( 1, s_Command, 3 )
	
	new i_CmdNum = str_to_num ( s_Command )
	
	if ( g_Mode[id] ) // Main test
	{
		if ( g_MainKeysTested[id][i_CmdNum] )
		{
			client_cmd ( id, "spk sound/buttons/button10.wav" )
			return PLUGIN_HANDLED
		}
		else
			g_MainKeysTested[id][i_CmdNum] = true
	}
	else
	{
		if ( g_OtherKeysTested[id][i_CmdNum] )
		{
			client_cmd ( id, "spk sound/buttons/button10.wav" )
			return PLUGIN_HANDLED
		}
		else
			g_OtherKeysTested[id][i_CmdNum] = true
	}
	
	client_cmd ( id, "spk sound/buttons/button9.wav" )
	DisplayTest ( id+TASK_TEST )
	
	g_Checked[id]++
	
	return PLUGIN_HANDLED
}

public DisplayTestMenu ( id )
{
	remove_task ( id+TASK_HURRY ) //   
	
	new s_MenuBody[256], menukeys = MENU_KEY_5 + MENU_KEY_6 + MENU_KEY_9
	new len = format ( s_MenuBody,255,"\y%L^n", id, "TITLE_MAIN" )
	len += format ( s_MenuBody[len],255-len,"^n\r5\w. %L", id, "START" )
	len += format ( s_MenuBody[len],255-len,"^n\r6\w. %L", id, "KICKME" )
	
	if ( get_pcvar_num ( g_Quick ) )
	{
		len += format ( s_MenuBody[len],255-len,"^n^n\r7\w. %L", id, "QUICK" )
		menukeys += MENU_KEY_7
	}
	
	len += format ( s_MenuBody[len],255-len,"^n^n\r9\w. %L", id, "HELP" )
	show_menu ( id, menukeys, s_MenuBody, _, "keyboard_menu" )
}

public DisplayKickMeMenu ( id )
{
	new s_MenuBody[256], len
	len = format ( s_MenuBody,255,"\y%L^n", id, "TITLE_KICKME" )
	len += format ( s_MenuBody[len],255-len,"^n\r2\w. %L", id, "MENU_YES" )
	len += format ( s_MenuBody[len],255-len,"^n\r3\w. %L", id, "MENU_NO" )
	show_menu ( id, MENU_KEY_2|MENU_KEY_3, s_MenuBody, _, "kickme_menu" )
}

public ActionMainMenu ( id, i_Key )
{
	switch ( i_Key )
	{
		case 4: // [5] OK, Let's go
		{
			g_TestStarted[id] = true
			client_cmd ( id, "writecfg backup" )
			DisplayTest ( id+TASK_TEST )
		}
		case 5: // [6] Kick
		{
			DisplayKickMeMenu ( id )
		}
		case 6: // [7] Quick
		{
			g_Mode[id] = g_TestStarted[id] = true
			client_cmd ( id, "writecfg backup" )
			DisplayTest ( id+TASK_TEST )
		}
		case 8: // [9] Help
		{
			DisplayMotd ( id )
		}
	}
}

public ActionKickMeMenu ( id, i_Key )
{
	switch ( i_Key )
	{
		case 1:
			server_cmd ( "kick #%i ^" %L^"", get_user_userid ( id ), id, "KICK_REASON" )
		case 2:
			DisplayTestMenu ( id )
	}
}

public DisplayMotd ( id )
{
	new s_MotdHelp[512], len
	len = formatex ( s_MotdHelp[len], sizeof s_MotdHelp - len, "<meta http-equiv=^"Content-Type^" content=^"text/html; charset=UTF-8^" />" )
	len += formatex ( s_MotdHelp[len], sizeof s_MotdHelp - len, "<body text=^"#FFFFFF^" bgcolor=^"#000000^">" )
	len += formatex ( s_MotdHelp[len], sizeof s_MotdHelp - len, "<center><font size=^"6^" color=^"#FF0000^">%L</font><br>", id, "MOTD_1" )
	len += formatex ( s_MotdHelp[len], sizeof s_MotdHelp - len, "%L<br><br><br><br>", id, "MOTD_2" )
	len += formatex ( s_MotdHelp[len], sizeof s_MotdHelp - len, "%L</center></body>", id, "MOTD_3" )
		
	new s_MotdTitle[32]
	formatex ( s_MotdTitle, sizeof s_MotdTitle - 1, "Giant Keyboard Test v%s", VERSION )
	show_motd ( id, s_MotdHelp, s_MotdTitle )
	
	DisplayTestMenu ( id )
}

public DisplayTest ( id )
{
	id-=TASK_TEST
	
	g_Afk[id] = 0
	remove_task ( id+TASK_HURRY )
	set_task ( 1.0, "HurryUP", id+TASK_HURRY, _, _, "b" )
	
	new s_MenuBody[384], s_Temp, len
	len = format ( s_MenuBody,255,"\y%L\w^n^n", id, "TITLE_HUD" )
	
	new i_Num = min ( g_LastKey[id] + get_pcvar_num(g_StageKeys), g_Mode[id]?i_MaxMainKeys:i_MaxOtherKeys )
	new bool:i_Checked
	if ( (g_Checked[id] + 1 == get_pcvar_num ( g_StageKeys )) || (g_LastKey[id] + g_Checked[id] + 1 == (g_Mode[id]?i_MaxMainKeys:i_MaxOtherKeys)) )
	{
		remove_task ( id+TASK_HURRY )
		i_Checked = true
	}
	
	for ( new i = g_LastKey[id]; i < i_Num; i++ )
	{
		client_cmd ( id, "bind ^"%s^" ^"%s %i^"", g_Mode[id]?g_MainKeys[i]:g_OtherKeys[i], g_Bind, i )
		s_Temp = i
		if ( s_Temp==get_pcvar_num(g_StageKeys)/2 )
		{
			if ( g_Mode[id] )
				len += formatex ( s_MenuBody[len], sizeof s_MenuBody - len, "[%s%s\w]^n", g_MainKeysTested[id][i]?"\y":"\r", g_MainKeys[i] )
			else
				len += formatex ( s_MenuBody[len], sizeof s_MenuBody - len, "[%s%s\w]^n", g_OtherKeysTested[id][i]?"\y":"\r", g_OtherKeys[i] )
			s_Temp=0
		}
		else
		{
			if ( g_Mode[id] )
				len += formatex ( s_MenuBody[len], sizeof s_MenuBody - len, "[%s%s\w] ", g_MainKeysTested[id][i]?"\y":"\r", g_MainKeys[i] )
			else
				len += formatex ( s_MenuBody[len], sizeof s_MenuBody - len, "[%s%s\w] ", g_OtherKeysTested[id][i]?"\y":"\r", g_OtherKeys[i] )
		}
	}
	len += format ( s_MenuBody[len],255-len,"^n%\r9%s. %L", i_Checked?"\y":"\d", id, "NEXT" )
	len += format ( s_MenuBody[len],255-len,"^n^n\r0\w. %L", id, "MENU_DONTWANT" )
	show_menu ( id, i_Checked?MENU_KEY_9|MENU_KEY_0:MENU_KEY_0, s_MenuBody, _, "test_menu" )
}

public ActionTestMenu ( id, i_Key )
{
	switch ( i_Key )
	{
		case 8:
		{
			g_LastKey[id] += get_pcvar_num(g_StageKeys)
			client_cmd ( id, "exec backup.cfg" )
			g_Checked[id] = 0
			
			if ( g_Mode[id] )
			{
				if ( g_LastKey[id] >= i_MaxMainKeys )
				{
					g_Afk[id] = 0
					remove_task ( id+TASK_HURRY )
					g_TestComplited[id] = true
					g_TestStarted[id] = false
					client_print ( id, print_chat, "[GKT] %L", id, "COMLETED" )
					client_cmd ( id, "jointeam 5" )
					return
				}
			}
			else
			{
				if ( g_LastKey[id] >= i_MaxOtherKeys )
				{
					g_LastKey[id] = 0
					g_Mode[id] = true
				}
			}
			
			remove_task ( id+TASK_TEST )
			set_task ( 0.5, "DisplayTest", id+TASK_TEST )
		}
		case 9:
		{
			server_cmd ( "kick #%i ^" %L^"", get_user_userid ( id ), id, "KICK_REASON" )
		}
	}
}

public HurryUP ( id )
{
	id -= TASK_HURRY
	
	g_Afk[id]++
	
	if ( g_Afk[id] >= get_pcvar_num ( g_HurryTime ) )
	{
		client_cmd ( id, "exec backup.cfg" )
		remove_task ( id+TASK_TEST )
		server_cmd ( "kick #%i ^" %L^"", get_user_userid ( id ), id, "KICK_TOLATE" )
	}
	else if ( g_Afk[id] > get_pcvar_num ( g_HurryTime ) / 2 )
	{
		set_hudmessage ( 0, 0, 255, -1.0, 0.04, 0, _, 1.0, _, _, 3 )
		show_hudmessage ( id, "%L", id, "HURRY", get_pcvar_num ( g_HurryTime ) - g_Afk[id] )
	}
}